package gov.va.vinci.dart.json;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(name="request", propOrder={
		"requestId",
		"trackingNumber",
		"amendment",
		"reviewId",
		"workflowId",
		"events"
})
public class EventRequestView {

	private int requestId;
	private String trackingNumber;
	private boolean amendment;
	private int reviewId = 0;
	private int workflowId = 0;
	
	@XmlElement(name="event")
	private List<EventView> events = new ArrayList<EventView>();

	
	public int getRequestId() {
		return requestId;
	}

	public void setRequestId(int requestId) {
		this.requestId = requestId;
	}
	
	public String getTrackingNumber() {
		return trackingNumber;
	}

	public void setTrackingNumber(String trackingNumber) {
		this.trackingNumber = trackingNumber;
	}
	
	public boolean isAmendment() {
		return amendment;
	}

	public void setAmendment(boolean amendment) {
		this.amendment = amendment;
	}

	public int getReviewId() {
		return reviewId;
	}

	public void setReviewId(int reviewId) {
		this.reviewId = reviewId;
	}

	public int getWorkflowId() {
		return workflowId;
	}

	public void setWorkflowId(int workflowId) {
		this.workflowId = workflowId;
	}
	
	
	public List<EventView> getEvents() {
		return events;
	}
}
